jQuery(document).ready(function($) {
    console.log("TRP Admin JS loaded");
    
    // Toggle API key visibility
    $("#toggle-api-key").click(function(e) {
        e.preventDefault();
        console.log("Toggle API key clicked");
        var apiKeyField = $("#trp_api_key");
        if (apiKeyField.attr("type") === "password") {
            apiKeyField.attr("type", "text");
            $(this).text("Hide");
        } else {
            apiKeyField.attr("type", "password");
            $(this).text("Show");
        }
    });
    
    // Test API key connection
    $("#test-api-key").click(function(e) {
        e.preventDefault();
        console.log("Test API key clicked");
        var apiKey = $("#trp_api_key").val();
        var baseUrl = $("input[name='trp_base_url']").val();
        var statusDiv = $("#api-key-status");
        
        if (!apiKey) {
            statusDiv.removeClass("success testing").addClass("error")
                .text("Please enter an API key first.");
            return;
        }
        
        if (!baseUrl) {
            statusDiv.removeClass("success error").addClass("error")
                .text("Please enter a base URL first.");
            return;
        }
        
        statusDiv.removeClass("success error").addClass("testing")
            .text("Testing connection...");
        
        $.ajax({
            url: ajaxurl,
            type: "POST",
            data: {
                action: "trp_test_api_key",
                api_key: apiKey,
                base_url: baseUrl,
                nonce: trp_admin_ajax.nonce
            },
            success: function(response) {
                if (response.success) {
                    statusDiv.removeClass("error testing").addClass("success")
                        .text("Connection successful! " + 
                              (response.data.tenant_name ? "(Tenant: " + response.data.tenant_name + ")" : ""));
                } else {
                    statusDiv.removeClass("success testing").addClass("error")
                        .text("Connection failed: " + response.data);
                }
            },
            error: function() {
                statusDiv.removeClass("success testing").addClass("error")
                    .text("Connection test failed. Please check your settings.");
            }
        });
    });
}); 