# Tenant Referral Program - Custom Fields Implementation Test Guide

## Changes Implemented

### 1. Settings Page Updates (`admin/class-admin-settings.php`)

#### New Settings Added:
- **Agreement Text Field** (`trp_agreement_text`)
  - Default: "I agree to the Terms & Conditions"
  - Allows basic HTML (strong, em, b, i, br)
  - Located in General Settings section

- **Terms URL Field** (`trp_terms_url`)
  - Default: "/terms-and-conditions/"
  - Accepts both relative paths and full URLs
  - Located in General Settings section

### 2. Sign-up Form Updates (`public/class-shortcodes.php`)

#### Changes Made:
- ✅ Form now uses custom agreement text from settings
- ✅ Form now uses custom terms URL from settings
- ✅ Marketing communications checkbox completely removed
- ✅ Smart link handling: if agreement text doesn't contain a link, adds a "(View)" link

## Testing Instructions

### Step 1: Verify Settings Page
1. Go to WordPress Admin → Settings → Referral Program
2. Look for two new fields in the General Settings section:
   - "Agreement Text" field
   - "Terms & Conditions URL" field
3. Try updating these values and save settings

### Step 2: Test Sign-up Form
1. Add the shortcode `[tenant_referral_signup_form]` to a page
2. Check that:
   - The agreement checkbox shows your custom text
   - The link points to your custom URL
   - The marketing communications checkbox is gone

### Step 3: Test Different Configurations

#### Test Case A: Default Values
- Leave settings empty
- Should show: "I agree to the Terms & Conditions" with link to "/terms-and-conditions/"

#### Test Case B: Custom Text and URL
- Set Agreement Text: "I accept the legal terms"
- Set Terms URL: "https://example.com/legal"
- Should show custom text with link to custom URL

#### Test Case C: Relative URL
- Set Terms URL: "/my-terms-page/"
- Should work with relative path

## Notes
- The marketing consent field is still processed in the backend (`class-form-handler.php`) but always defaults to false since the checkbox is removed from the form
- Form validation still requires the terms agreement checkbox to be checked
- Both fields have proper sanitization to prevent XSS attacks